//
//  YHDisappointHKAlertView.swift
//  galaxy
//
//  Created by edy on 2024/8/26.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import AttributedString

class YHDisappointHKAlertView: UIView {

    var confirmBlock:(()->())?
    
    lazy var blackMaskView: UIView = {
        let view = UIView()
        view.backgroundColor = .alertMaskColor
        return view
    }()
    
    lazy var whiteContentView: UIView = {
        let view = UIView()
        view.backgroundColor = .white
        view.layer.cornerRadius = kCornerRadius6
        return view
    }()
    
    lazy var iconImgView: UIImageView = {
        let view = UIImageView(image: UIImage(named: "guide_no_appoint_hk"))
        return view
    }()
    
    lazy var titleLabel: UILabel = {
        let label = UILabel()
        label.textAlignment = .center
        label.font = UIFont.PFSC_M(ofSize: 17)
        label.textColor = UIColor.mainTextColor
        label.text = "暂未预约"
        return label
    }()
    
    lazy var detailLabel: UILabel = {
        var label = UILabel()
        label.numberOfLines = 0
        label.font = UIFont.PFSC_R(ofSize: 14.0)
        let a: ASAttributedString = .init("您暂时", .font(UIFont.PFSC_R(ofSize: 14)),.foreground(UIColor.mainTextColor(alpha: 0.7)))
        let b: ASAttributedString = .init("没有进行赴港预约", .font(UIFont.PFSC_B(ofSize: 14)),.foreground(UIColor.brandMainColor))
        let c: ASAttributedString = .init("，无有效行程", .font(UIFont.PFSC_R(ofSize: 14)),.foreground(UIColor.mainTextColor(alpha: 0.7)))
        label.attributed.text = a+b+c
        return label
    }()
    
    lazy var confirmBtn: UIButton = {
        let button = UIButton()
        button.titleLabel?.font = UIFont.PFSC_R(ofSize: 14)
        button.setTitle("前往预约", for: .normal)
        button.setTitleColor(UIColor.white, for: .normal)
        button.backgroundColor = .brandMainColor
        button.addTarget(self, action: #selector(didConfirmBtnClicked), for: .touchUpInside)
        button.layer.cornerRadius = kCornerRadius3
        return button
    }()
    
    lazy var closeBtn:UIButton = {
        let btn = UIButton()
        btn.setImage(UIImage(named: "update_close"), for: .normal)
        btn.addTarget(self, action: #selector(didCloseBtnClicked), for: .touchUpInside)
        return btn
    }()
    
    static func alertView() -> YHDisappointHKAlertView {
        let view = YHDisappointHKAlertView(frame: UIScreen.main.bounds)
        return view
    }
    
    @objc func show() {
        UIApplication.shared.yhKeyWindow()?.addSubview(self)
    }
    
    @objc func dismiss() {
        self.removeFromSuperview()
    }
    
    @objc func didCloseBtnClicked() {
        dismiss()
    }
    
    @objc func didConfirmBtnClicked() {
        confirmBlock?()
        self.dismiss()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        createUI()
    }
    
    func createUI() {
        
        self.addSubview(blackMaskView)
        self.addSubview(whiteContentView)
        self.addSubview(closeBtn)
        whiteContentView.addSubview(iconImgView)
        whiteContentView.addSubview(titleLabel)
        whiteContentView.addSubview(detailLabel)
        whiteContentView.addSubview(confirmBtn)
        
        blackMaskView.snp.makeConstraints { make in
            make.edges.equalToSuperview()
        }
        
        whiteContentView.snp.makeConstraints { make in
            make.left.equalTo(38)
            make.right.equalTo(-38)
            make.centerY.equalToSuperview().offset(-24)
        }
        
        iconImgView.snp.makeConstraints { make in
            make.width.height.equalTo(100)
            make.top.equalTo(32)
            make.centerX.equalToSuperview()
        }
        
        titleLabel.snp.makeConstraints { make in
            make.top.equalTo(iconImgView.snp.bottom).offset(16)
            make.height.equalTo(24)
            make.left.equalTo(21)
            make.right.equalTo(-21)
        }
        
        detailLabel.snp.makeConstraints { make in
            make.left.equalTo(21)
            make.right.equalTo(-21)
            make.top.equalTo(titleLabel.snp.bottom).offset(8)
        }
        
        confirmBtn.snp.makeConstraints { make in
            make.top.equalTo(detailLabel.snp.bottom).offset(42)
            make.left.equalTo(21)
            make.right.equalTo(-21)
            make.bottom.equalTo(-21)
            make.height.equalTo(45)
        }
        
        closeBtn.snp.makeConstraints { make in
            make.width.height.equalTo(24)
            make.top.equalTo(whiteContentView.snp.bottom).offset(24)
            make.centerX.equalTo(whiteContentView)
        }
    }
}
